# [![Mattermost](https://user-images.githubusercontent.com/7205829/137170381-fe86eef0-bccc-4fdd-8e92-b258884ebdd7.png)](https://mattermost.com)

[Mattermost](https://mattermost.com) is an open source platform for secure collaboration across the entire software development lifecycle. This repo is the primary source for core development on the Mattermost platform; it's written in Go and React and runs as a single Linux binary with MySQL or PostgreSQL. A new compiled version is released under an MIT license every month on the 16th.

<img width="1006" alt="mattermost-hero" src="https://user-images.githubusercontent.com/7205829/136107976-7a894c9e-290a-490d-8501-e5fdbfc3785a.png">

Useful Resources:

- [Deployment Guide](https://docs.mattermost.com/guides/deployment.html) - Install, setup, and configure your own Mattermost instance.
- [Admin and User Documentation](https://docs.mattermost.com/) - Learn how to run a Mattermost instance and take advantage of all the features.
- [Developer Documentation](https://developers.mattermost.com/) - Contribute code to Mattermost or build an integration via APIs, Webhooks, slash commands, Apps, and plugins.

Table of Contents
=================

  * [Try out Mattermost](#try-out-mattermost)
  * [Install Mattermost](#install-mattermost)
  * [Native Mobile and Desktop Apps](#native-mobile-and-desktop-apps)
  * [Get Security Bulletins](#get-security-bulletins)
  * [Get Involved](#get-involved)
  * [Learn More](#learn-more)
  * [Get the Latest News](#get-the-latest-news)
  * [Contributing](#contributing)

## Try out Mattermost

- [Join the Mattermost Contributor's server](https://community.mattermost.com/signup_user_complete/?id=codoy5s743rq5mk18i7u5ksz7e) to join community discussions about contributions, development and more
- [Get started with Mattermost Cloud](https://customers.mattermost.com/cloud/signup) to try out Mattermost

[![Deploy a Preview](https://www.herokucdn.com/deploy/button.svg)](https://heroku.com/deploy?template=https://github.com/mattermost/mattermost-heroku)

_Note: Heroku preview does not include email or persistent storage_

## Install Mattermost

- [Quick Install Guide](https://docs.mattermost.com/getting-started/light-install.html) - Deploy in minutes via Mattermost Omnibus on Ubuntu.
- [Run Mattermost via Docker](https://docs.mattermost.com/install/setting-up-local-machine-using-docker.html) - Launch a Mattermost server instantly to test functionality and build integrations.
- [Developer Machine Setup](https://developers.mattermost.com/contribute/server/developer-setup) - Follow this guide if you want to write code for Mattermost.

Other Install Guides:
- [Ubuntu 20.04 LTS](https://docs.mattermost.com/install/installing-ubuntu-2004-LTS.html)
- [Kubernetes](https://docs.mattermost.com/install/install-kubernetes.html)
- [Helm](https://docs.mattermost.com/install/install-kubernetes.html#installing-the-operators-via-helm)
- [Debian Buster](https://docs.mattermost.com/install/install-debian.html)
- [RHEL 8](https://docs.mattermost.com/install/install-rhel-8.html)
- [More server install guides](https://docs.mattermost.com/guides/deployment.html)

## Native Mobile and Desktop Apps

In addition to the web interface, you can also download Mattermost clients for [Android](https://play.google.com/store/apps/details?id=com.mattermost.rn), [iOS](https://itunes.apple.com/us/app/mattermost/id1257222717?mt=8), [Windows PC](https://docs.mattermost.com/install/desktop.html#windows-10-windows-8-1-windows-7), [Mac OSX](https://docs.mattermost.com/install/desktop.html#macos-10-9), and [Linux](https://docs.mattermost.com/install/desktop.html#linux).

[![Google Play](https://user-images.githubusercontent.com/33878967/33095356-39b6fbf8-ceb8-11e7-8a61-c3a18fa5e658.png)](https://play.google.com/store/apps/details?id=com.mattermost.rn)  [![App Store](https://user-images.githubusercontent.com/33878967/33095353-397e69b4-ceb8-11e7-8175-f95a97d5274f.png)](https://itunes.apple.com/us/app/mattermost/id1257222717?mt=8)  [![Windows PC](https://user-images.githubusercontent.com/33878967/33095357-39cab8d2-ceb8-11e7-89a6-67dccc571ca3.png)](https://docs.mattermost.com/install/desktop.html#windows-10-windows-8-1-windows-7)  [![Mac OSX](https://user-images.githubusercontent.com/33878967/33095355-39a36f2a-ceb8-11e7-9b33-73d4f6d5d6c1.png)](https://docs.mattermost.com/install/desktop.html#macos-10-9)  [![Linux](https://user-images.githubusercontent.com/33878967/33095354-3990e256-ceb8-11e7-965d-b00a16e578de.png)](https://docs.mattermost.com/install/desktop.html#linux)

## Get Security Bulletins

Receive notifications of critical security updates. The sophistication of online attackers is perpetually increasing. If you are deploying Mattermost it is highly recommended you subscribe to the Mattermost Security Bulletin mailing list for updates on critical security releases.

[Subscribe here](https://mattermost.com/security-updates/#sign-up)

## Get Involved

- [Contribute to Mattermost](https://handbook.mattermost.com/contributors/contributors/ways-to-contribute)
- [Find "Help Wanted" projects](https://github.com/mattermost/mattermost-server/issues?page=1&q=is%3Aissue+is%3Aopen+%22Help+Wanted%22&utf8=%E2%9C%93)
- [Join Developer Discussion on a Mattermost Server for contributors](https://community.mattermost.com/signup_user_complete/?id=f1924a8db44ff3bb41c96424cdc20676)
- [Get Help With Mattermost](https://docs.mattermost.com/guides/get-help.html)

## Learn More

- [API Options - webhooks, slash commands, drivers and web service](https://api.mattermost.com/)
- [See who's using Mattermost](https://mattermost.com/blog/category/customer-stories/)
- [Browse over 700 Mattermost integrations](https://integrations.mattermost.com/)

## License

See the [LICENSE file](LICENSE.txt) for license rights and limitations.

## Get the Latest News

- **Twitter** - Follow [Mattermost](https://twitter.com/mattermost).
- **Blog** - Get the latest updates from the [Mattermost blog](https://mattermost.com/blog/).
- **Facebook** - Follow [Mattermost](https://www.facebook.com/MattermostHQ).
- **LinkedIn** - Follow [Mattermost](https://www.linkedin.com/company/mattermost/).
- **Email** - Subscribe to our [newsletter](https://mattermost.us11.list-manage.com/subscribe?u=6cdba22349ae374e188e7ab8e&id=2add1c8034) (1 or 2 per month).
- **Mattermost** - Join the ~contributors channel on [the Mattermost Community Server](https://community.mattermost.com). 
- **IRC** - Join the #matterbridge channel on [Freenode](https://freenode.net/) (thanks to [matterircd](https://github.com/42wim/matterircd)).

## Contributing
Please see [CONTRIBUTING.md](./CONTRIBUTING.md).

Any other questions, mail us at info@mattermost.com. We’d love to meet you!
